/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import net.coobird.thumbnailator.ThumbnailParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThumbnailatorUtils {
    private ThumbnailatorUtils() {
    }

    public static List<String> getSupportedOutputFormats() {
        String[] stringArray = ImageIO.getWriterFormatNames();
        if (stringArray == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(stringArray);
    }

    public static boolean isSupportedOutputFormat(String string2) {
        if (string2 == ThumbnailParameter.ORIGINAL_FORMAT) {
            return true;
        }
        for (String string3 : ThumbnailatorUtils.getSupportedOutputFormats()) {
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getSupportedOutputFormatTypes(String string2) {
        String[] stringArray;
        if (string2 == ThumbnailParameter.ORIGINAL_FORMAT) {
            return Collections.emptyList();
        }
        Iterator<ImageWriter> iterator2 = ImageIO.getImageWritersByFormatName(string2);
        if (!iterator2.hasNext()) {
            return Collections.emptyList();
        }
        try {
            stringArray = iterator2.next().getDefaultWriteParam().getCompressionTypes();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return Collections.emptyList();
        }
        if (stringArray == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(stringArray);
    }

    public static boolean isSupportedOutputFormatType(String string2, String string3) {
        if (!ThumbnailatorUtils.isSupportedOutputFormat(string2)) {
            return false;
        }
        if (string2 == ThumbnailParameter.ORIGINAL_FORMAT && string3 == ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
            return true;
        }
        if (string2 == ThumbnailParameter.ORIGINAL_FORMAT && string3 != ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
            return false;
        }
        if (string3 == ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
            return true;
        }
        for (String string4 : ThumbnailatorUtils.getSupportedOutputFormatTypes(string2)) {
            if (!string4.equals(string3)) continue;
            return true;
        }
        return false;
    }
}

